/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.query.IVWScopeChangeListener;
import filenet.vw.toolkit.utils.query.VWDateTimeErrDialog;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class VWRosterQueueSelectionPanel
extends JPanel
implements IVWScopeChangeListener,
IVWMouseActionListener {
    public static final int TYPE_QUEUE = 0;
    public static final int TYPE_ROSTER = 1;
    private JTextField m_startTimeTextField = null;
    private JTextField m_endTimeTextField = null;
    private JComboBox m_timeUnitsComboBox = null;
    private VWAddRemovePanel m_addRemovePanel = null;
    private JPopupMenu m_popup;

    public VWRosterQueueSelectionPanel(int nType) {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            this.add((Component)this.createControlPanel(), "First");
            this.m_addRemovePanel = new VWAddRemovePanel(10);
            this.m_addRemovePanel.enableSorting(768);
            this.add((Component)this.m_addRemovePanel, "Center");
            this.setType(nType);
            this.createPopupMenu();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDisplayName() {
        return VWResource.s_criteria;
    }

    public Date getEndTime(boolean bDialog) {
        Date date = null;
        if (this.m_endTimeTextField != null && this.m_endTimeTextField.getText().length() > 0) {
            int count = VWFieldsCellEditor.s_dateTimeFormatters.length;
            for (int i = 0; i < count; ++i) {
                try {
                    date = VWFieldsCellEditor.s_dateTimeFormatters[i].parse(this.m_endTimeTextField.getText());
                    if (date == null) continue;
                    break;
                }
                catch (ParseException ex) {
                    if (i != count - 1 || !bDialog) continue;
                    VWDateTimeErrDialog errDlg = new VWDateTimeErrDialog(null, VWResource.s_error, VWResource.s_invalidEndTimeFormat, 0);
                    errDlg.setVisible(true);
                    date = null;
                }
            }
        }
        return date;
    }

    public Date getStartTime(boolean bDialog) {
        Date date = null;
        if (this.m_startTimeTextField != null && this.m_startTimeTextField.getText().length() > 0) {
            int count = VWFieldsCellEditor.s_dateTimeFormatters.length;
            for (int i = 0; i < count; ++i) {
                try {
                    date = VWFieldsCellEditor.s_dateTimeFormatters[i].parse(this.m_startTimeTextField.getText());
                    if (date == null) continue;
                    break;
                }
                catch (ParseException ex) {
                    if (i != count - 1 || !bDialog) continue;
                    VWDateTimeErrDialog errDlg = new VWDateTimeErrDialog(null, VWResource.s_error, VWResource.s_invalidStartTimeFormat, 0);
                    errDlg.setVisible(true);
                    date = null;
                }
            }
        }
        return date;
    }

    public String[] getSelectedItems() {
        if (this.m_addRemovePanel != null) {
            return this.m_addRemovePanel.getSelectedStringItems();
        }
        return null;
    }

    public int getTimeUnits() {
        if (this.m_timeUnitsComboBox != null) {
            return this.m_timeUnitsComboBox.getSelectedIndex() + 1;
        }
        return -1;
    }

    public void setType(int nType) {
        switch (nType) {
            case 0: {
                this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableQueues);
                this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedQueues);
                break;
            }
            case 1: {
                this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableRosters);
                this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedRosters);
            }
        }
    }

    public boolean getIsCurrentTime() {
        Date startTime = this.getStartTime(false);
        Date endTime = this.getEndTime(false);
        if (startTime == null && endTime == null) {
            return true;
        }
        return startTime != null && endTime != null && startTime.equals(endTime);
    }

    public void scopeChanged(VWScopeChangeEvent event) {
        try {
            this.m_addRemovePanel.initializeLists(event.getRespositoryNames(), null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
    }

    public void createPopup(MouseEvent event) {
        if (this.m_popup != null) {
            this.m_popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private JPanel createControlPanel() {
        JPanel subPanel = null;
        GridBagConstraints gbCons = null;
        JLabel label1 = null;
        JLabel label2 = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(0, 10, 0, 10);
            label1 = new JLabel(VWResource.s_intervalStartTime);
            VWAccessibilityHelper.setAccessibility(label1, this, VWResource.s_intervalStartTime, VWResource.s_intervalStartTime);
            this.m_startTimeTextField = new JTextField();
            VWAccessibilityHelper.setAccessibility(this.m_startTimeTextField, this, VWResource.s_intervalStartTime, VWResource.s_intervalStartTime);
            VWAccessibilityHelper.setLabelFor(label1, this.m_startTimeTextField);
            label2 = new JLabel(VWResource.s_timeUnits);
            VWAccessibilityHelper.setAccessibility(label2, this, VWResource.s_timeUnits, VWResource.s_timeUnits);
            this.addRowControls(label1, this.m_startTimeTextField, label2, subPanel, gbCons);
            label1 = new JLabel(VWResource.s_intervalEndTime);
            VWAccessibilityHelper.setAccessibility(label1, this, VWResource.s_intervalEndTime, VWResource.s_intervalEndTime);
            this.m_endTimeTextField = new JTextField();
            VWAccessibilityHelper.setAccessibility(this.m_endTimeTextField, this, VWResource.s_intervalEndTime, VWResource.s_intervalEndTime);
            VWAccessibilityHelper.setLabelFor(label1, this.m_endTimeTextField);
            this.m_timeUnitsComboBox = new JComboBox(this.getTimeUnitOptions());
            VWAccessibilityHelper.setAccessibility(this.m_timeUnitsComboBox, this, VWResource.s_timeUnits, VWResource.s_timeUnits);
            VWAccessibilityHelper.setLabelFor(label1, this.m_timeUnitsComboBox);
            this.addRowControls(label1, this.m_endTimeTextField, this.m_timeUnitsComboBox, subPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private void addRowControls(Component comp1, Component comp2, Component comp3, JPanel panel, GridBagConstraints gbCons) {
        try {
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add(comp1, gbCons);
            gbCons.gridwidth = -1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            panel.add(comp2, gbCons);
            gbCons.gridwidth = 0;
            gbCons.weightx = 0.3;
            panel.add(comp3, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Vector getTimeUnitOptions() {
        Vector<String> items = null;
        try {
            items = new Vector<String>();
            items.addElement(VWResource.s_minutes);
            items.addElement(VWResource.s_hours);
            items.addElement(VWResource.s_days);
            items.addElement(VWResource.s_weeks);
            items.addElement(VWResource.s_months);
            items.addElement(VWResource.s_years);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    private void createPopupMenu() {
        this.m_popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(VWResource.s_syntaxHelp);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_General + "bpfwd030.htm");
            }
        });
        this.m_popup.add(menuItem);
        this.m_startTimeTextField.addMouseListener(new VWMouseAdapter(this));
        this.m_endTimeTextField.addMouseListener(new VWMouseAdapter(this));
    }
}

